[![Professional Support](https://www.totaljs.com/img/badge-support.svg)](https://www.totaljs.com/support/) [![Chat with contributors](https://www.totaljs.com/img/badge-chat.svg)](https://messenger.totaljs.com) [![NPM version][npm-version-image]][npm-url] [![NPM quality][npm-quality]](http://packagequality.com/#?package=total.js) [![NPM downloads][npm-downloads-image]][npm-url] [![MIT License][license-image]][license-url] [![Build Status][travis-image]][travis-url] [![Gitter chat](https://badges.gitter.im/totaljs/framework.png)](https://messenger.totaljs.com)

Node.js framework
=================

__Total.js framework__ is a framework for Node.js platfrom written in `pure` JavaScript similar to PHP's Laravel or Python's Django or ASP.NET MVC. It can be used as web, desktop, service or IoT application.

__IMPORTANT__: [New version __Total.js 4__](github.com/totaljs/framework4)

```bash
$ npm install -g total.js
```

- [Total.js Code editor](http://www.totaljs.com/code/)
- [Total.js CMS](http://www.totaljs.com/cms/)
- [Total.js Eshop](http://www.totaljs.com/eshop/)
- [Total.js Wiki](https://www.totaljs.com/wiki/)
- [Total.js Flow](https://www.totaljs.com/flow/)
- [Total.js Flowboard](https://www.totaljs.com/flowboard/)
- [Total.js Messenger](https://www.totaljs.com/messenger/)
- [Total.js Dashboard](https://www.totaljs.com/dashboard/)
- [Total.js BlogEngine](https://www.totaljs.com/blogengine/)
- [Total.js SuperAdmin](https://www.totaljs.com/superadmin/)
- [Total.js HelpDesk](https://www.totaljs.com/helpdesk/)
- [Total.js OpenPlatform](https://www.totaljs.com/openplatform/)
- [Total.js +100 examples](https://github.com/totaljs/examples)
- [NoSQL embedded database explorer](https://www.totaljs.com/nosql/)
- [Download +200 UI components for free](https://componentator.com)
- [Download +100 CMS widgets for free](https://componentator.com/widgets/)

---

- [Website](http://www.totaljs.com)
- [__Get Started__](http://www.totaljs.com/get-started/)
- [__Documentation__](http://docs.totaljs.com)
- [__Wiki for Total.js products__](http://wiki.totaljs.com)
- [__Live chat with professional support__](https://platform.totaljs.com?app=messenger)
- [__Total.js Blog__](https://blog.totaljs.com)
- [__Membership__](https://platform.totaljs.com)
- [Changelog](https://github.com/totaljs/framework/blob/master/changes.txt)

## Official support

- [Support form](http://www.totaljs.com/support/)
- Support e-mail: <support@totaljs.com>

| Top features |
|------|
| [__Offline documentation__](http://docs.totaljs.com) |
| __Backward compatibility__ |
| HMVC architecture |
| Clean directory structure |
| Fully asynchronous |
| Full web server with serving of static files |
| Supports IP restrictions |
| Supports redirections |
| Supports reusable components |
| Supports just-in-time JS, CSS (variables and nesting) and HTML compressor |
| Supports just-in-time merging of static files (JavaScripts, CSS or HTML) |
| Supports just-in-time mapping of files |
| Supports media streaming (e.g. videos) |
| Supports modules and packages |
| Built-in image processing engine via ImageMagick or GraphicsMagick |
| Supports WebSockets (__RFC 6455__) and Server-Sent events |
| __NEW__ Supports WebSockets client |
| Supports `multipart/x-mixed-replace` (IP camera streaming) uploading and sending |
| Supports RESTful routing |
| Supports middleware (like express.js) with custom options |
| Supports unit testing |
| Supports workers for heavy CPU operations |
| Supports 4x config files (common, debug, release and test) |
| Mailer with templating (Gmail, Outlook or classic SMTP servers with auth and TLS) |
| Built-in view engine (layouts, nested views, conditions, loops, inline helpers, etc.) |
| Localization with diff tool and CSV export |
| Supports cache mechanism |
| Supports schemas for creating business objects with validations, workflows, etc. |
| Supports injecting scripts, packages and views from URL |
| Supports String, Date, Number and Array prototypes |
| Supports additional utilities (e.g. create request, XML parsing, etc.) |
| Supports themes |
| Supports scripting |
| Possibility to rewrite existing functionality |
| NoSQL embedded database

## Social networks

Please support the framework on social networks.

- [Follow Total.js on Gitter](https://gitter.im/totaljs/framework)
- [Follow Total.js on GitHub](https://github.com/totaljs/framework)
- [Follow Total.js on Twitter - __@totalframework__](https://twitter.com/totalframework)
- [Follow Total.js on Facebook](https://www.facebook.com/totaljs.web.framework)
- [Follow Total.js on LinkedIn](https://www.linkedin.com/groups/totaljs-8109884)

## Contact

- (c) 2012-2021 by Peter Širka - <petersirka@gmail.com>
- contact form <https://www.totaljs.com/contact/>
- <info@totaljs.com>

[license-image]: https://img.shields.io/badge/license-MIT-blue.svg?style=flat
[license-url]: license.txt

[npm-url]: https://npmjs.org/package/total.js
[npm-version-image]: https://img.shields.io/npm/v/total.js.svg?style=flat
[npm-downloads-image]: https://img.shields.io/npm/dm/total.js.svg?style=flat
[npm-quality]: http://npm.packagequality.com/shield/total.js.svg

[travis-url]: https://travis-ci.org/totaljs/framework
[travis-image]: https://img.shields.io/travis/totaljs/framework.svg?style=flat