const TrezSmsClient = require("trez-sms-client");
//if(CONFIG("Rusername")!== undefined && CONFIG("Rpassword")!== undefined){
    const client = new TrezSmsClient(CONFIG("Rusername"),CONFIG("Rpassword"));
//}


const fsi = require('fs');



/*
<define>
    #connection : ایجاد ارتباط با مرکز داده مونگو دی بی 
    #database   :           ===> نام بانک اطلاعاتی مورد نظر
    #colection       ===> نام کالکشن(جدول)
    #query     : یک پرس و جو برای دریافت اطلاعات از کالکشن
    #projection    : یک لیست برای دریافت اطلاعات خاص از کالکشن
    #sort    :object ===> ({_id:1}|{_id:-1})
    #int50    :("1" .... 50)
    #int50+    :("0" .... 50)
    #int100    :("1" .... 100)
    #int     :("1" .... infinit)
    #url      - Example ==> "www.https-co.com"
    #text     - Example ==> "https-co"
    #position : ("north"|"northeast"|"northwest"|"south"|"southeast"|"southwest"|"east"|"west","center") 


    #connection     - Example ==> conn_auth(url,user,pass)
    #database       - Example ==> "https"
    #colection      - Example ==> "user"
    #query          - Example ==> {_id:8} or {name:"ali"}
    #projection     - Example ==> {_id:1,name:0}

    \!      important
    \~      neccesery
    /<<       start selection
    >>/       end selection

</define>

<define>
    #customer number ===> شماره مشتری - Example ==> "09121135611"
    #customer number array ===> آرایه ای از شماره های مشتریان - Example ==> ["09121135611","09305708319"]
    #operator number ===> سرشماره ارسال کننده پیام
    #operator number array ===> آرایه ای از سرشماره ارسال کننده پیام
    
    #shortCODEtext     - Example ==> "کد تایید شما 45555 \n" + "تراشه توانمند پارت\n https-co.com" 
    #shorttext     - Example ==> "تراشه توانمند پارت\n https-co.com" 

    #SMStext      ===> متن پیام شما
    
    
    
    
    #sms       ===> پسوند فایل
    #file = PATH.public('images/#subtarget/#name.#ext');
    #color   - Example ==> "red" or "#ffdc34"
    #int+    :("0" .... infinit)
    #int50    :("1" .... 50)
    #int50+    :("0" .... 50)
    #int100    :("1" .... 100)
    #int     :("1" .... infinit)
    #shorttext     - Example ==> "تراشه توانمند پارت\n https-co.com" 
    #text     - Example ==> "تراشه توانمند پارت\n https-co.com" 
    #position : ("north"|"northeast"|"northwest"|"south"|"southeast"|"southwest"|"east"|"west","center") 


    source   - Example ==> PATH.public('images/subfolder/start.jpg') 
    target   - Example ==> PATH.public('images/subfolder/finaly.jpg') \\ !important
    \!      important
    \~      neccesery
    /<<       start selection
    >>/       end selection

</define>
*/



/////////////////////////////////////////// RayganSMS
/*<summary>
    <name> manualSendCode </name>
    <inputs>
    (Cnumber shorttext)
        Cnumber (#customer number) \!
        text (#shorttext) \!
    </inputs>
    <returns>
        output ===> object type
        output.status ===> 200 برای اجرای درست;
        output.status ===> 500 برای اجرای نادرست;
        output.status ===> 700 برای مشکل فنی;
        status=200 ==> output.data    ===> کد عملکرد در مرکز پیام رسان
        status=500 ==> output.data    ===> پیام خطای عملکرد در مرکز پیام رسان
        status=700 ==> output.data    ===> پیام خطای سیستم
    </returns> 
</summary>
 */
 exports.A_RautoSendCode = async function (Cnumber, shorttext){
     return await new  Promise((resolve, reject) => {
         let output={};
         try{
            client.autoSendCode(Cnumber,shorttext)
            .then((messageId) => {
                output.status=200;
                output.data=messageId;
                resolve(output);
            })
            .catch((error) => {
                output.status=500;
                output.data=error.isHttpException+"\n"+error.code+"\n"+error.message;
                reject(output);
        	});
         }catch(err){
                 output.status=700;
                output.data=err;
                reject(output);
         }
     });
 }
  exports.RautoSendCode = function (Cnumber, shorttext){
         let output={};
         try{
            client.autoSendCode(Cnumber,shorttext)
            .then((messageId) => {
                output.status=200;
                output.data=messageId;
                return output;
            })
            .catch((error) => {
                output.status=500;
                output.data=error.isHttpException+"\n"+error.code+"\n"+error.message;
                return output;
        	});
         }catch(err){
                 output.status=700;
                output.data=err;
                return output;
         }
  }
/*<summary>
    <name> RmSendCode </name>
    <inputs>
    (Cnumber shorttext)
        Cnumber (#customer number) \!
        text (#shortCODEtext) \!
    </inputs>
</summary>
 */
 exports.A_RmanualSendCode = async function (Cnumber, shorttext){
     return await new  Promise((resolve, reject) => {
         let output={};
         try{
            client.manualSendCode(Cnumber,shorttext)
            .then((messageId) => {
                output.status=200;
                output.data=messageId;
                console.log(output.data);
                resolve(output);
            })
            .catch((error) => {
                output.status=500;
                output.data=error.isHttpException+"\n"+error.code+"\n"+error.message;
                console.log(output.data);
                resolve(output);
        	});
         }catch(err){
                 output.status=700;
                output.data=err;
                console.log(output.data);
                resolve(output);
         }
     });
 }
  exports.RmanualSendCode = function (Cnumber, shorttext){
         let output={};
         try{
            client.manualSendCode(Cnumber,shorttext)
            .then((messageId) => {
                output.status=200;
                output.data=messageId;
                console.log(output.data);
                return output;
            })
            .catch((error) => {
                output.status=500;
                output.data=error.isHttpException+"\n"+error.code+"\n"+error.message;
                console.log(output.data);
                return output;
        	});
         }catch(err){
                 output.status=700;
                output.data=err;
                console.log(output.data);
                return output;
         }
  }
 /*<summary>
    <name> RchkCode </name>
    <inputs>
    (Cnumber, CnumberARR, shorttext, text)
        #customer number ===> شماره مشتری - Example ==> "09121135611"
    #customer number array ===> آرایه ای از شماره های مشتریان - Example ==> ["09121135611","09305708319"]

        Cnumber (#customer number) \!
        CnumberARR (#customer number array) \!
        width  (#int)  \!
        height (#int)  \!
    </inputs>
    <returns>
        output ===> object type
        output.status ===> 200 برای اجرای درست;
        output.status ===> 500 برای اجرای نادرست;
        output.status ===> 700 برای مشکل فنی;
        status=200 ==> output.data    ===> کد عملکرد در مرکز پیام رسان
        status=500 ==> output.data    ===> پیام خطای عملکرد در مرکز پیام رسان
        status=700 ==> output.data    ===> پیام خطای سیستم
    </returns> 
</summary>
 */
  exports.A_RcheckCode = async function (Cnumber, code){
     return await new  Promise(async(resolve, reject) => {
         let output={};
         try{
            client.checkCode(Cnumber,code)
            .then((messagebool) => { 
                output.status=200;
                output.data=messagebool;
                console.log(output.data);
                resolve(output);
            })
            .catch((error) => {
                output.status=500;
                output.data=error.isHttpException+"\n"+error.code+"\n"+error.message;
                console.log(output.data);
                resolve(output);
        	});
         }catch(err){
                 output.status=700;
                output.data=err;
                console.log(output.data);
                resolve(output);
         }
     });
 }
   exports.RcheckCode = function (Cnumber, code){
         let output={};
         try{
            client.checkCode(Cnumber,code)
            .then((messagebool) => {
                output.status=200;
                output.data=messagebool;
                console.log(output.data);
                return output;
            })
            .catch((error) => {
                output.status=500;
                output.data=error.isHttpException+"\n"+error.code+"\n"+error.message;
                console.log(output.data);
                return output;
        	});
         }catch(err){
                 output.status=700;
                output.data=err;
                console.log(output.data);
                return output;
         }
  }

 /*<summary>
    <name> RSendMessage </name>
        #customer number ===> شماره مشتری - Example ==> "09121135611"
    #customer number array ===> آرایه ای از شماره های مشتریان - Example ==> ["09121135611","09305708319"]
    #operator number ===> سرشماره ارسال کننده پیام
    #operator number array ===> آرایه ای از سرشماره ارسال کننده پیام
    
    #shortCODEtext     - Example ==> "کد تایید شما 45555 \n" + "تراشه توانمند پارت\n https-co.com" 
    #shorttext     - Example ==> "تراشه توانمند پارت\n https-co.com" 

    #SMStext      ===> متن پیام شما
    

</summary>
 */
 exports.A_RSendMessage = async function (Onumber, Cnumber, text, groupId){
     return await new  Promise((resolve, reject) => {
         let output={};
         try{
            client.sendMessage(Onumber, Cnumber, text, groupId)
            .then((receipt) => {
                output.status=200;
                output.data=receipt;
                resolve(output);
            })
            .catch((error) => {
                output.status=500;
                output.data=error.isHttpException+"\n"+error.code+"\n"+error.message;
                reject(output);
        	});
         }catch(err){
                 output.status=700;
                output.data=err;
                reject(output);
         }
     });
 }
  exports.RSendMessage = function (Onumber, Cnumber, text, groupId){
         let output={};
         console.log(Cnumber);
         return true;
         try{
            client.sendMessage(Onumber, Cnumber, text, groupId)
            .then((receipt) => {
                output.status=200;
                output.data=receipt;
                console.log(output);
                return output;
            })
            .catch((error) => {
                output.status=500;
                output.data=error.isHttpException+"\n"+error.code+"\n"+error.message;
                console.log(output);
                return output;
        	});
         }catch(err){
                 output.status=700;
                output.data=err;
                console.log(output);
                return output;
         }
  }
	
	/*<summary>
    <name> RSendP2P </name>
    ["Unique ID",  "Cnumber", "SMStext"]
    ArrayList=[
    {"id":"114578","cn":"9121135611","sms":"This is test message"}
    ,{"id":"114579","cn":"09381938160","sms":"This is other message"}
    ,{"id":"114580","cn":"09305708319","sms":"This is another message"}
    ]
</summary>
 */



 exports.A_RSendP2P = async function (Onumber, ArrayList, groupId){
     return await new  Promise((resolve, reject) => {
         let output={};
         const recipients = [];
         ArrayList.forEach((item,index)=>{
             recipients[index]=client.createRecipientObject(item.id,item.cn,item.sms);
         });
         ArrayList=[];
         try{
            client.sendBatchMessage(Onumber, recipients, groupId)
            .then((result) => {
                output.status=200;
                output.data=result;// [{"Id":11445599,"Mobile":"09123456789","Result":2000}, {"Id":99854710,"Mobile":"09301234567","Result":2001}]
                resolve(output);
            })
            .catch((error) => {
                output.status=500;
                output.data=error.isHttpException+"\n"+error.code+"\n"+error.message;
                reject(output);
        	});
         }catch(err){
                 output.status=700;
                output.data=err;
                reject(output);
         }
     });
 }
  exports.RSendP2P = function (Onumber, ArrayList, groupId){
         let output={};
         const recipients = [];
         ArrayList.forEach((item,index)=>{
             recipients[index]=client.createRecipientObject(item.id,item.cn,item.sms);
         });
         ArrayList=[];
         try{
            client.sendBatchMessage(Onumber, recipients, groupId)
            .then((result) => {
                output.status=200;
                output.data=result;// [{"Id":11445599,"Mobile":"09123456789","Result":2000}, {"Id":99854710,"Mobile":"09301234567","Result":2001}]
                return output;
            })
            .catch((error) => {
                output.status=500;
                output.data=error.isHttpException+"\n"+error.code+"\n"+error.message;
                return output;
        	});
         }catch(err){
                 output.status=700;
                output.data=err;
                return output;
         }
  }	
	

/*<summary>
    <name> RCredit </name>
    <inputs>
    (source, target, width, height)
        source (#file) \!
        target (#file) \!
        height (#int)  \!
    </inputs>
    <returns>
        output ===> object type
        output.status ===> 200 برای اجرای درست;
        output.status ===> 500 برای اجرای نادرست;
        output.status ===> 404 فایل یافت نشد;
        output.data    ===> برای 200 فایل از نوع بافر;
        output.data    ===> برای 404 پیام ارور سیستم;
    </returns> 
</summary>
 */
 exports.A_RCredit = async function (){
     return await new  Promise((resolve, reject) => {
         let output={};
         try{
            client.accountCredit()
            .then((credit) => {
                output.status=200;
                output.data=credit;// (credit + " Rials"); // 500000 Rials
                resolve(output);
            })
            .catch((error) => {
                output.status=500;
                output.data=error.isHttpException+"\n"+error.code+"\n"+error.message;
                reject(output);
        	});
         }catch(err){
                 output.status=700;
                output.data=err;
                reject(output);
         }
     });
 }
  exports.RCredit = function (){
         let output={};
         try{
            client.accountCredit()
            .then((credit) => {
                output.status=200;
                output.data=credit;// (credit + " Rials"); // 500000 Rials
                return output;
            })
            .catch((error) => {
                output.status=500;
                output.data=error.isHttpException+"\n"+error.code+"\n"+error.message;
                return output;
        	});
         }catch(err){
                 output.status=700;
                output.data=err;
                return output;
         }
  }	
	
	
/*<summary>
    <name> RPrices </name>
    <inputs>
    (source, target, width, height)
        source (#file) \!
        target (#file) \!
        height (#int)  \!
    </inputs>
    <returns>
        output ===> object type
        output.status ===> 200 برای اجرای درست;
        output.status ===> 500 برای اجرای نادرست;
        output.status ===> 404 فایل یافت نشد;
        output.data    ===> برای 200 فایل از نوع بافر;
        output.data    ===> برای 404 پیام ارور سیستم;
    </returns> 
</summary>
 */

 exports.A_RPrices = async function (){
     return await new  Promise((resolve, reject) => {
         let output={};
         try{
            client.prices()
            .then((credit) => {
                output.status=200;
                output.data=credit;// "Farsi: " + prices.fa + " Rials, English: " + prices.en + " Rials")
                resolve(output);
            })
            .catch((error) => {
                output.status=500;
                output.data=error.isHttpException+"\n"+error.code+"\n"+error.message;
                reject(output);
        	});
         }catch(err){
                 output.status=700;
                output.data=err;
                reject(output);
         }
     });
 }
  exports.RPrices = function (){
         let output={};
         try{
            client.prices()
            .then((credit) => {
                output.status=200;
                output.data=credit;// "Farsi: " + prices.fa + " Rials, English: " + prices.en + " Rials")
                return output;
            })
            .catch((error) => {
                output.status=500;
                output.data=error.isHttpException+"\n"+error.code+"\n"+error.message;
                return output;
        	});
         }catch(err){
                 output.status=700;
                output.data=err;
                return output;
         }
  }	