const fs=require('fs');
exports.fs=fs;
/*
<summary>
    <name> openfile </name>
    <inputs>
        #subtarget ===> نام سایر زیر پوشه ها
        #name      ===> نام فایل
        #ext       ===> پسوند فایل
        name = PATH.public('images/#subtarget/#name.#ext');
    </inputs>
    <returns>
        output ===> object type
        output.status ===> 200 برای اجرای درست;
        output.status ===> 404 برای اجرای نادرست;
        output.data    ===> برای 200 فایل از نوع بافر;
        output.data    ===> برای 404 پیام ارور سیستم;
    </returns> 
</summary>
*/
exports.openfile = async function (name){
    return await new  Promise(async(resolve, reject) => {
        let output={};
        try{
            output.status=200;
            output.data=fs.readFileSync(name);
        }catch(err){
            output.status=404;
            output.data=err;
        }
        resolve(output);
  });
};
/*
<summary>
    <name> CHKopenfile </name>
    <inputs>
        #subtarget ===> نام سایر زیر پوشه ها
        #name      ===> نام فایل
        #ext       ===> پسوند فایل
        name = PATH.public('images/#subtarget/#name.#ext');
    </inputs>
    <returns>
        output ===> object type
        output.status ===> 200 برای اجرای درست;
        output.status ===> 500 برای اجرای نادرست;
        output.status ===> 404 فایل یافت نشد;
        output.data    ===> برای 200 فایل از نوع بافر;
        output.data    ===> برای 404 پیام ارور سیستم;
    </returns> 
</summary>
 */
exports.CHKopenfile = async function (name){
    return await new  Promise(async(resolve, reject) => {
        var chk=await exports.checkfile(name);
        if(chk.data){
            try{
                output.status=200;
                output.data=fs.readFileSync(name);
            }catch(err){
                output.status=500;
                output.data=err;
            }
        }else{
            output.status=404;
            output.data="File not found";
        }
        resolve(output);
  });
};
/*
<summary>
    <name> checkfile </name>
    <inputs>
        #subtarget ===> نام سایر زیر پوشه ها
        #name      ===> نام فایل
        #ext       ===> پسوند فایل
        name = PATH.public('images/#subtarget/#name.#ext');
    </inputs>
    <returns>
        output ===> object type
        output.status ===> 200 برای اجرای درست;
        output.status ===> 404 برای اجرای نادرست;
        output.data    ===> true برای اجرای درست;
        output.data    ===> false برای اجرای نادرست;
    </returns> 
</summary>
*/  
exports.checkfile = async function (name){
    return await new  Promise(async(resolve, reject) => {
        let output={};
        try{
            output.status=200;
            output.data=fs.existsSync(name);
        }catch(err){
            output.status=404;
            output.data=err;
        }
        resolve(output);
    });
};
/*
<summary>
    <name> copyTO </name>
    <inputs>
        #num       ===> اندیس مورد نظر برای فایل
                        برای ارسال چند فایل از 0 تا تعداد منهای یک
                        در صورت ارسال تکی این عدد 0 است
        file       ===> self.files[#num];
        #subtarget ===> نام سایر زیر پوشه ها
        #name      ===> نام فایل
        #ext       ===> پسوند فایل
        name = PATH.public('images/#subtarget/#name.#ext');
    </inputs>
    <returns>
        output ===> object type
        output.status ===> 200 برای اجرای درست;
        output.status ===> 404 برای اجرای نادرست;
        output.data    ===> برای 200 فایل از نوع بافر;
        output.data    ===> برای 404 پیام ارور سیستم;
    </returns> 
</summary>
*/  
exports.copyTO = async function (file,name){
    return await new  Promise(async(resolve, reject) => {
        let output={};
        try{
            output.status=200;
            output.data=file.copy(name);
        }catch(err){
            output.status=404;
            output.data=err;
        }
        resolve(output);
    });
};


//////////////// rename    move       chkmove 
/*
<summary>
    <name> deletefile </name>
    <inputs>
        #subtarget ===> نام سایر زیر پوشه ها
        #name      ===> نام فایل
        #ext       ===> پسوند فایل
        name = PATH.public('images/#subtarget/#name.#ext');
    </inputs>
    <returns>
        output ===> object type
        output.status ===> 200 برای اجرای درست;
        output.status ===> 404 برای اجرای نادرست;
        output.data    ===> برای 200 فایل از نوع بافر;
        output.data    ===> برای 404 پیام ارور سیستم;
    </returns> 
</summary>
*/  
exports.deletefile = async function (name){
    return await new  Promise(async(resolve, reject) => {
        let output={};
        try{
            output.status=200;
            output.data=fs.unlink(name);
        }catch(err){
            output.status=404;
            output.data=err;
        }
        resolve(output);
  });
};
/*
<summary>
    <name> CHKdeletefile </name>
    <inputs>
        #subtarget ===> نام سایر زیر پوشه ها
        #name      ===> نام فایل
        #ext       ===> پسوند فایل
        name = PATH.public('images/#subtarget/#name.#ext');
    </inputs>
    <returns>
        output ===> object type
        output.status ===> 200 برای اجرای درست;
        output.status ===> 404 برای اجرای نادرست;
        output.data    ===> برای 200 فایل از نوع بافر;
        output.data    ===> برای 404 پیام ارور سیستم;
    </returns> 
</summary>
*/  
exports.CHKdeletefile = async function (name){
    return await new  Promise(async(resolve, reject) => {
        const chk=await checkfile(name);
        let output={};
        if(chk.status==200){
            try{
                output.status=200;
                output.data=fs.unlink(name);
            }catch(err){
                output.status=500;
                output.data=err;
            }
         }else{
            output.status=404;
            output.data="File Not Found";
        }
        resolve(output);
  });
};





/*
<summary>
    <name> openfile </name>
    <inputs>
        #subtarget ===> نام سایر زیر پوشه ها
        #name      ===> نام فایل
        #ext       ===> پسوند فایل
        name = PATH.public('images/#subtarget/#name.#ext');
    </inputs>
    <returns>
        output ===> object type
        output.status ===> 200 برای اجرای درست;
        output.status ===> 404 برای اجرای نادرست;
        output.data    ===> برای 200 فایل از نوع بافر;
        output.data    ===> برای 404 پیام ارور سیستم;
    </returns> 
</summary>
*/  
// exports.openfile = async function (name){
//     return await new  Promise(async(resolve, reject) => {
//         let output={};
//         try{
//             output.status=200;
//             output.data=fs.readFileSync(name);
//             resolve(output);
//         }catch(err){
//             output.status=404;
//             output.data=err;
//             reject(output);
//         }
//   });
// };

//exports.load_image = exports.openfile;
exports.CHKload_image = exports.CHKopenfile;
exports.checkimage = exports.checkfile;

/*
<summary>
    <name> read_jasoFile </name>
    <inputs>
        #subtarget ===> نام سایر زیر پوشه ها
        #name      ===> نام فایل
        name = PATH.public('images/#subtarget/#name.json');
    </inputs>
    <returns>
        output ===> object type
        output.status ===> 200 برای اجرای درست;
        output.status ===> 404 برای اجرای نادرست;
        output.data    ===> برای 200 یک آبجک لیست;
        output.data    ===> برای 404 پیام ارور سیستم;
    </returns> 
</summary>
*/  
exports.read_jasoFile = async function (name){
    return await new  Promise(async(resolve, reject) => {
        let output={};
        try{
            output.status=200;
            output.data=JSON.parse(fs.readFileSync(name));
        }catch(err){
            output.status=404;
            output.data=err;
        }
        resolve(output);
    });
};
/*
<summary>
    <name> write_jasoFile </name>
    <inputs>
        #subtarget ===> نام سایر زیر پوشه ها
        #name      ===> نام فایل
        name = PATH.public('images/#subtarget/#name.json');
    </inputs>
    <returns>
        output ===> object type
        output.status ===> 200 برای اجرای درست;
        output.status ===> 404 برای اجرای نادرست;
        output.data    ===> برای 200 یک آبجک لیست;
        output.data    ===> برای 404 پیام ارور سیستم;
    </returns> 
</summary>
*/  
exports.write_jasoFile = async function (name,list){
    return await new  Promise(async(resolve, reject) => {
        let output={};
        try{
            output.status=200;
            output.data=fs.writeFileSync(fs_name, JSON.stringify(list));
        }catch(err){
            output.status=404;
            output.data=err;
        }
        resolve(output);
    });
};

////////////////////////////////////////////////////
// using System;
// using System.Collections.Generic;
// using System.Linq;
// using System.Web;
// using System.Globalization;
// namespace johargostar.HTTPS_Class
// {
//     public  class Persian_Date
//     {
//         DateTime dt = DateTime.Now;
//         PersianCalendar p = new PersianCalendar();
//         private  int _Day_Date = 0;
//         private  int _mount = 0;
//         private int _Year_Date = 0;
//         private string _Mounth_Date = "";
//         private string _weak_Date = "";
//         private string _NewsDate = "";
//         private string m, d,time;
//         public int Year_Date
//         {
//             get
//             {
//                 return _Year_Date = Convert.ToInt32(p.GetYear(dt).ToString());
//             }
//         }
//         public string Mounth_Date
//         {
//             get
//             {
//                 string[] mah = { "فروردین", "اردیبهشت", "خرداد", "تیر", "مرداد", "شهریور", "مهر", "آبان", "آذر", "دی", "بهمن", "اسفند" };

//                 return _Mounth_Date = mah[p.GetMonth(dt)- 1];
//             }
//         }
//         public int mount
//         {
//             get
//             {
//                 return _mount = p.GetMonth(dt);
//             }
//         }
//         public string NewsDate
//         {
//             get
//             {
//                 m = p.GetMonth(dt).ToString();
//                 if (p.GetMonth(dt) < 10)
//                 {
//                     m = "0" + p.GetMonth(dt);
//                 }
//                 d = p.GetDayOfMonth(dt).ToString();
//                 if (p.GetDayOfMonth(dt) < 10)
//                 {
//                     d = "0" + p.GetDayOfMonth(dt);
//                 }
//                 _NewsDate = p.GetYear(dt) + "/" + m + "/" + d.ToString();
//                 return _NewsDate;
//             }
//         }
//         public string peygiri
//         {
//             get
//             {
//                 m = p.GetMonth(dt).ToString();
//                 if (p.GetMonth(dt) < 10)
//                 {
//                     m = "0" + p.GetMonth(dt);
//                 }
//                 d = p.GetDayOfMonth(dt).ToString();
//                 if (p.GetDayOfMonth(dt) < 10)
//                 {
//                     d = "0" + p.GetDayOfMonth(dt);
//                 }
//                 string s = dt.ToString("HH:mm:ss");
//                 time = dt.ToString("HHmmss");
//                 _NewsDate = p.GetYear(dt)+m+ d.ToString()+time;
//                 return _NewsDate;
//             }
//         }
//         public int Day_Date
//         {
//             get
//             {
//                 _Day_Date = Convert.ToInt32(p.GetDayOfMonth(dt).ToString());
//                 return _Day_Date;
//             }   
//        }
//         public string weak_Date
//         {
//             get
//             {
//                 switch (p.GetDayOfWeek(dt).ToString())
//                 {
//                     case "Saturday":
//                         _weak_Date = "شنبه";
//                         break;
//                     case "Sunday":
//                         _weak_Date = "یکشنبه";
//                         break;
//                     case "Monday":
//                         _weak_Date = "دوشنبه";
//                         break;
//                     case "Tuesday":
//                         _weak_Date = "سه شنبه";
//                         break;
//                     case "Wednesday":
//                         _weak_Date = "چهارشنبه";
//                         break;
//                     case "Thursday":
//                         _weak_Date = "پنج شنبه";
//                         break;
//                     case "Friday":
//                         _weak_Date = "جمعه";
//                         break;
//                     default:
//                         _weak_Date = "not set";
//                         break;
//                 };
//                 return _weak_Date;
//             }
//         }
//         public Persian_Date()
//         {

//         }
//     }
// }



// using System;
// using System.Collections.Generic;
// using System.Linq;
// using System.Web;

// namespace johargostar.HTTPS_Class
// {
//     public class Readnews
//     {
//         public static string rdnews(string Text,int cont)
//         {
//             string result = "";
//             int j = cont;
//             if (Text.Length< cont)
//             {
//                 j = Text.Length-1;
//             }
//             result = Text.Substring(0, j);
//             string[] sp = result.Split(' ');
//                 result = "";
//                 for (int i = 0; i< sp.Length - 1; i++)
//                      {
//                 result += sp[i]+" ";
//                      }

//             result += "...";
//             return result;
            
//         }
//         public static string rdnews(string Text)
//         {
//             string result = "";
//             int j = 250;
//             if (Text.Length < 250)
//             {
//                 j = Text.Length - 1;
//             }
//             result = Text.Substring(0, j);
//             string[] sp = result.Split(' ');
//             result = "";
//             for (int i = 0; i < sp.Length - 1; i++)
//             {
//                 result += sp[i] + " ";
//             }

//             result += "...";
//             return result;

//         }
//         public static string brnews(string Text)
//         {
 
//             return Text.Replace("\n", "<br/>");
//         }
//     }
// }
// using System;
// using System.Collections.Generic;
// using System.Drawing;
// using System.Drawing.Drawing2D;
// using System.IO;
// using System.Linq;
// using System.Web;
// using System.Web.Mvc;

// namespace johargostar.HTTPS_Class
// {
//     public class FileTools
//     {
//         public Boolean filesearch(HttpRequestBase request, string address, string name, string extention)
//         {
//             try
//             {
//                 string pt = request.MapPath("~/" + address + "/" + name +"."+ extention);
//                 if (File.Exists(pt))
//                 {
//                     return true;
//                 }else{
//                     return false;
//                 }
//             }
//             catch (Exception ex)
//             {

//                 //ViewBag.Message = "ERROR:" + ex.Message.ToString();
//                 return false;

//             }

//         }
//         public void Filedelete(HttpRequestBase request, string picadress, string oldname, string extention)
//         {
//             try
//             {
//                 //            //File.Delete("~/img/product/" + "thumb-"+ oldname + ".jpg");
//                 //string pt = request.MapPath(@"~/"+picadress+"thumb-"+ oldname+extention);
//                 //string pt1 = request.MapPath(@"~/"+ picadress + oldname + extention);

//                 string pt = request.MapPath("~/" + picadress + "/thumb-" + oldname +"."+ extention);
//                 string pt1 = request.MapPath("~/" + picadress+"/" + oldname +"."+ extention);
//                 if (File.Exists(pt))
//                 {
//                     System.IO.File.Delete(pt);

//                 }
//                 if (File.Exists(pt1))
//                 {
//                     System.IO.File.Delete(pt1);

//                 }
//             }
//             catch (Exception ex)
//             {

//                 //ViewBag.Message = "ERROR:" + ex.Message.ToString();

//             }

//         }
//         public void FileMoveRename(HttpRequestBase request, string SourceAddress, string SourceName, string SourceExtention, string TargerAddress, string TargerName, string TargerExtention)
//         {
//             try
//             {
//                 string source = request.MapPath("~/" + SourceAddress + SourceName + SourceExtention);
//                 string target = request.MapPath("~/" + TargerAddress + TargerName + TargerExtention);
//                 if (System.IO.File.Exists(source))
//                 {

//                     System.IO.File.Move(source, target);

//                 }
//             }
//             catch (Exception ex)
//             {

//                 //ViewBag.Message = "ERROR:" + ex.Message.ToString();

//             }

//         }
//         public void FileMove(HttpRequestBase request, string SourceAddress, string SourceName, string SourceExtention, string TargerAddress)
//         {
//             FileMoveRename(request, SourceAddress, SourceName, SourceExtention, TargerAddress, SourceName, SourceExtention);
//         }
//         public void FileMove(HttpRequestBase request, string SourceAddress, string SourceName, string SourceExtention, string TargerAddress, string TargerName)
//         {
//             FileMoveRename(request, SourceAddress, SourceName, SourceExtention, TargerAddress, TargerName, SourceExtention);
//         }
//         public void FileMove(HttpRequestBase request, string SourceAddress, string SourceName, string SourceExtention, string TargerAddress, string TargerName, string TargerExtention)
//         {
//             FileMoveRename(request, SourceAddress, SourceName, SourceExtention, TargerAddress, TargerName, TargerExtention);
//         }

//         public void FileRename(HttpRequestBase request, string SourceAddress, string SourceName, string SourceExtention, string TargerName)
//         {
//             FileMoveRename(request, SourceAddress, SourceName, SourceExtention, SourceAddress, TargerName, SourceExtention);
//         }
//         public void FileRename(HttpRequestBase request, string SourceAddress, string SourceName, string SourceExtention, string TargerName, string TargerExtention)
//         {
//             FileMoveRename(request, SourceAddress, SourceName, SourceExtention, SourceAddress, TargerName, TargerExtention);
//         }
//         public void Fileupload(HttpRequestBase request, HttpServerUtilityBase server, string PictureName, string picadress, string extention, HttpPostedFileBase file)
//         {
//             try
//             {


//                 //request.Files[0] as HttpPostedFileBase;
//                 if (file != null && file.ContentLength > 0)
//                 {
//                     string path = Path.Combine(server.MapPath(@"~/" + picadress), PictureName +"."+ extention);
//                     file.SaveAs(path);

//                     // ResizeStream(picsize, hpf.InputStream, path);

//                     //string path = Path.Combine(server.MapPath("~/img/home/silder"), "silder" + SliderId + ".jpg");
//                 }


//             }
//             catch (Exception ex)
//             {

//                 //ViewBag.Message = "ERROR:" + ex.Message.ToString();

//             }

//         }
//     }
// }
