var MongoClient = require('mongodb').MongoClient;
/*
<define>
    #connection : ایجاد ارتباط با مرکز داده مونگو دی بی 
    #database   :           ===> نام بانک اطلاعاتی مورد نظر
    #colection       ===> نام کالکشن(جدول)
    #query     : یک پرس و جو برای دریافت اطلاعات از کالکشن
    #projection    : یک لیست برای دریافت اطلاعات خاص از کالکشن
    #sort    :object ===> ({_id:1}|{_id:-1})
    #int50    :("1" .... 50)
    #int50+    :("0" .... 50)
    #int100    :("1" .... 100)
    #int     :("1" .... infinit)
    #url      - Example ==> "www.https-co.com"
    #text     - Example ==> "https-co"
    #position : ("north"|"northeast"|"northwest"|"south"|"southeast"|"southwest"|"east"|"west","center") 


    #connection     - Example ==> conn_auth(url,user,pass)
    #database       - Example ==> "https"
    #colection      - Example ==> "user"
    #query          - Example ==> {_id:8} or {name:"ali"}
    #projection     - Example ==> {_id:1,name:0}

    \!      important
    \~      neccesery
    /<<       start selection
    >>/       end selection

</define>
*/
/////////////////////////////////////////// connections
/*<summary>
    <name> conn </name>
    <inputs>
        (conn,dbase,collection,query,protion,sort)
        conn        (#file) \! 
        dbase       (#file) \!
        collection  (#int)  \!
        /<<
        query       (#int)  \!      ==> Default : {}
        protion     (#int)  \!      ==> Default : {yo:0}
        sort        (#int)  \!      ==> Default : {id:1}
        >>/
    </inputs>
    <returns>
        output ===> object type include {status,data}
        output.status 
            case 200:
                connected to mondodb and you can use of output.data in another functions
            case 500:
                connection refused and you can use Error in output.data
    </returns> 
</summary>
 */
exports.conn=async	function (url){
    var urlfix = "mongodb://"+url+"/";
    // var conn=await MongoClient.connect(urlfix,{ useNewUrlParser: true, useUnifiedTopology: true });
    // return conn;
     return await new  Promise(async(resolve, reject) => {
        let output={};
        try{
            output.status=200;
            output.data=await MongoClient.connect(urlfix,{ useNewUrlParser: true, useUnifiedTopology: true });
       }catch(err){
           output.status=500;
           output.data=err;
       }
        resolve(output);
    });
}


exports.connfull=async	function (url){
    var urlfix = "mongodb://"+url;
  
     return await new  Promise(async(resolve, reject) => {
        let output={};
        try{
            output.status=200;
            output.data=await MongoClient.connect(urlfix,{ useNewUrlParser: true, useUnifiedTopology: true });
       }catch(err){
           output.status=500;
           output.data=err;
       }
        resolve(output);
    });
}
 



exports.connS=async	function (url,user,pass){
    var urlfix = "mongodb://"+url+"/?ssl=true";
     var conn=await MongoClient.connect(urlfix,{ useNewUrlParser: true, useUnifiedTopology: true });
     return conn;
}
exports.conn_auth=async	function (url,user,pass){
    var urlfix = "mongodb://"+user+":"+pass+"@"+url+"/";
     var conn=await MongoClient.connect(urlfix,{ useNewUrlParser: true, useUnifiedTopology: true });
     return conn;
}
exports.connS_auth=async function (url,user,pass){
    var urlfix = "mongodb://"+user+":"+pass+"@"+url+"/?ssl=true";
     var conn=await MongoClient.connect(urlfix,{ useNewUrlParser: true, useUnifiedTopology: true });
     return conn;
}
exports.conn_mongo=async	function (url){
    var urlfix = "mongodb://"+url+"/";
    //var url = "mongodb://localhost:27017/";
     var conn=await MongoClient.connect(urlfix,{ useNewUrlParser: true, useUnifiedTopology: true });
     return conn;
}

exports.disconn=function (conn){
    conn.close();
}

exports.ISvalidate=function(item){
    if(item==undefined ||	item=="" ){return false;}else{return true;}
}

////////////////////////////////////////
/////////////////////////////////////////
////////////////////////////////////////
// exports.dbo=async function (conn,dbase){
//      return await new  Promise(async(resolve, reject) => {
//         let output={};
//         try{
//             output.status=200;
//             output.data=await conn.db(dbase);
//        }catch(err){
//            output.status=500;
//            output.data=err;
//        }
//         resolve(output);
//     });
// }

/////////////////////////////////////////// autoincrement
/*<summary>
    <name> increment </name>
    <inputs>
        (conn,dbase,collection,query,protion,sort,skip,limit)
        conn        (#connection) \! 
        dbase       (#text) \!
        collection  (#text)  \!
        /<<text
        query       (#query)  \!      ==> Default : {}
        protion     (#projection)  \!      ==> Default : {yo:0}
        sort        (#sort)  \!      ==> Default : {id:1}
        skip        (#int)  \!      ==> Default : 0
        limit       (#int)  \!      ==> Default : 0
        >>/
    </inputs>
    <returns>
        output ===> object type
        output.status ===> 200 برای اجرای درست;
        output.status ===> 500 برای اجرای نادرست;
        output.status ===> 404 فایل یافت نشد;
        output.data    ===> برای 200 فایل از نوع بافر;
        output.data    ===> برای 404 پیام ارور سیستم;
    </returns> 
</summary>
 */
exports.increment=async function(conn,dbase,collection,startid,idcounter,val){
    const dbo = conn.db(dbase);
    return await new  Promise(async(resolve, reject) => {
        let output={},set={},projec={};
        try{
            output.status=200;
            set[idcounter]=1;
            projec[idcounter]=val;
            // output.data=await dbo.collection(collection).updateOne(filter,{$set:set});
            // output.data=await dbo.collection(collection).update(filter,set);
            output.data=await dbo.collection(collection).findOneAndUpdate({ _id:startid },{ $inc: set },{ upsert: true,projection: projec,returnNewDocument: false});
            output.idnum=output.data.value[idcounter]+1;
            resolve(output);
        }catch(err){
            output.status=500;
            output.data=err;
            resolve(output);

        }
    });
}
/*<summary>
    <name> idmaker </name>
    <inputs>
        (conn,dbase,collection,query,protion,sort,skip,limit)
        conn        (#connection) \! 
        dbase       (#text) \!
        collection  (#text)  \!
        /<<text
        query       (#query)  \!      ==> Default : {}
        protion     (#projection)  \!      ==> Default : {yo:0}
        sort        (#sort)  \!      ==> Default : {id:1}
        skip        (#int)  \!      ==> Default : 0
        limit       (#int)  \!      ==> Default : 0
        >>/
    </inputs>
    <returns>
        output ===> object type
        output.status ===> 200 برای اجرای درست;
        output.status ===> 500 برای اجرای نادرست;
        output.status ===> 404 فایل یافت نشد;
        output.data    ===> برای 200 فایل از نوع بافر;
        output.data    ===> برای 404 پیام ارور سیستم;
    </returns> 
</summary>
 */
exports.idmaker=async function(conn,dbase,collection,startid,idcounter){
    const dbo = conn.db(dbase);
    return await new  Promise(async(resolve, reject) => {
        let output={},set={},projec={};
        try{
            output.status=200;
            set[idcounter]=1;
            projec[idcounter]=1;
            // output.data=await dbo.collection(collection).updateOne(filter,{$set:set});
            // output.data=await dbo.collection(collection).update(filter,set);
            output.data=await dbo.collection(collection).findOneAndUpdate({ _id:startid },{ $inc: set },{ upsert: true,projection: projec,returnNewDocument: false});
            output.idnum=output.data.value[idcounter]+1;
            resolve(output);
        }catch(err){
            output.status=500;
            output.data=err;
            resolve(output);

        }
    });
}
/////////////////////////////////////////// empty
/*<summary>
    <name> insertONE </name>
    <inputs>
        (conn,dbase,collection,query,protion,sort,skip,limit)
        conn        (#connection) \! 
        dbase       (#text) \!
        collection  (#text)  \!
        /<<text
        query       (#query)  \!      ==> Default : {}
        protion     (#projection)  \!      ==> Default : {yo:0}
        sort        (#sort)  \!      ==> Default : {id:1}
        skip        (#int)  \!      ==> Default : 0
        limit       (#int)  \!      ==> Default : 0
        >>/
    </inputs>
    <returns>
        output ===> object type
        output.status ===> 200 برای اجرای درست;
        output.status ===> 500 برای اجرای نادرست;
        output.status ===> 404 فایل یافت نشد;
        output.data    ===> برای 200 فایل از نوع بافر;
        output.data    ===> برای 404 پیام ارور سیستم;
    </returns> 
</summary>
 */
exports.empty=async function(conn,dbase,collection){
    const dbo = conn.db(dbase);
    return await new  Promise(async(resolve, reject) => {
        let output={};
        try{
            output.status=200;
            output.data=await dbo.collection(collection).remove( { } );
            resolve(output);
        }catch(err){
            output.status=500;
            output.data=err;
            resolve(output);

        }
    });
}



exports.piccounterFREE=async function(conn,dbase,collection,id){
    const dbo = conn.db(dbase);
    return await new  Promise(async(resolve, reject) => {
        let output={},findTHEN={},ch;
        try{
            output.status=200;
            findTHEN=await dbo.collection(collection).find({_id:id*1}).toArray();
            ch=findTHEN[0].ax.split(',');
            if(ch.length<9){
                var num=findTHEN[0].axc+1;
                await dbo.collection(collection).updateOne({_id:id*1},{$set:{ax:findTHEN[0].ax+num+",",axc:num}});
                output.data=num;
            }else{
                output.status=401;
                output.data="limit 8 pic";
            }
            resolve(output);
        }catch(err){
            output.status=500;
            output.data=err;
            resolve(output);

        }
    });
}

/////////////////////////////////////////// insert
/*<summary>
    <name> insertONE </name>
    <inputs>
        (conn,dbase,collection,query,protion,sort,skip,limit)
        conn        (#connection) \! 
        dbase       (#text) \!
        collection  (#text)  \!
        /<<text
        query       (#query)  \!      ==> Default : {}
        protion     (#projection)  \!      ==> Default : {yo:0}
        sort        (#sort)  \!      ==> Default : {id:1}
        skip        (#int)  \!      ==> Default : 0
        limit       (#int)  \!      ==> Default : 0
        >>/
    </inputs>
    <returns>
        output ===> object type
        output.status ===> 200 برای اجرای درست;
        output.status ===> 500 برای اجرای نادرست;
        output.status ===> 404 فایل یافت نشد;
        output.data    ===> برای 200 فایل از نوع بافر;
        output.data    ===> برای 404 پیام ارور سیستم;
    </returns> 
</summary>
 */
exports.insertONE=async function(conn,dbase,collection,insertobj){
    const dbo = conn.db(dbase);
    return await new  Promise(async(resolve, reject) => {
        let output={};
        try{
            output.status=200;
            output.data=await dbo.collection(collection).insertOne(insertobj);
            resolve(output);
        }catch(err){
            output.status=500;
            output.data=err;
            resolve(output);

        }
    });
}


/////////////////////////////////////////// create index
/*<summary>
    <name> insertONE </name>
    <inputs>
        (conn,dbase,collection,query,protion,sort,skip,limit)
        conn        (#connection) \! 
        dbase       (#text) \!
        collection  (#text)  \!
        /<<text
        query       (#query)  \!      ==> Default : {}
        protion     (#projection)  \!      ==> Default : {yo:0}
        sort        (#sort)  \!      ==> Default : {id:1}
        skip        (#int)  \!      ==> Default : 0
        limit       (#int)  \!      ==> Default : 0
        >>/
    </inputs>
    <returns>
        output ===> object type
        output.status ===> 200 برای اجرای درست;
        output.status ===> 500 برای اجرای نادرست;
        output.status ===> 404 فایل یافت نشد;
        output.data    ===> برای 200 فایل از نوع بافر;
        output.data    ===> برای 404 پیام ارور سیستم;
    </returns> 
</summary>
 */
exports.createIndex=async function(conn,dbase,collection,indexobj){
    const dbo = conn.db(dbase);
    return await new  Promise(async(resolve, reject) => {
        let output={};
        try{
            output.status=200;
            output.data=await dbo.collection(collection).createIndex(indexobj);
            resolve(output);
        }catch(err){
            output.status=500;
            output.data=err;
            resolve(output);

        }
    });
}



/////////////////////////////////////////// ensure index
/*<summary>
    <name> insertONE </name>
    <inputs>
        (conn,dbase,collection,query,protion,sort,skip,limit)
        conn        (#connection) \! 
        dbase       (#text) \!
        collection  (#text)  \!
        /<<text
        query       (#query)  \!      ==> Default : {}
        protion     (#projection)  \!      ==> Default : {yo:0}
        sort        (#sort)  \!      ==> Default : {id:1}
        skip        (#int)  \!      ==> Default : 0
        limit       (#int)  \!      ==> Default : 0
        >>/
    </inputs>
    <returns>
        output ===> object type
        output.status ===> 200 برای اجرای درست;
        output.status ===> 500 برای اجرای نادرست;
        output.status ===> 404 فایل یافت نشد;
        output.data    ===> برای 200 فایل از نوع بافر;
        output.data    ===> برای 404 پیام ارور سیستم;
    </returns> 
</summary>
 */
exports.ensureIndex=async function(conn,dbase,collection,indexobj){
    const dbo = conn.db(dbase);
    return await new  Promise(async(resolve, reject) => {
        let output={};
        try{
            output.status=200;
            output.data=await dbo.collection(collection).ensureIndex(indexobj);
            resolve(output);
        }catch(err){
            output.status=500;
            output.data=err;
            resolve(output);

        }
    });
}

/*<summary>
    <name> insertFull </name>
    <inputs>
        (conn,dbase,collection,query,protion,sort,skip,limit)
        conn        (#connection) \! 
        dbase       (#text) \!
        collection  (#text)  \!
        /<<text
        insertobj       (#query)  \!      ==> Example : [{},{},...]
        protion     (#projection)  \!      ==> Default : {yo:0}
        sort        (#sort)  \!      ==> Default : {id:1}
        skip        (#int)  \!      ==> Default : 0
        limit       (#int)  \!      ==> Default : 0
        >>/
    </inputs>
    <returns>
        output ===> object type
        output.status ===> 200 برای اجرای درست;
        output.status ===> 500 برای اجرای نادرست;
        output.status ===> 404 فایل یافت نشد;
        output.data    ===> برای 200 فایل از نوع بافر;
        output.data    ===> برای 404 پیام ارور سیستم;
    </returns> 
</summary>
 */
exports.insertBulk=async function(conn,dbase,collection,insertobj){
    const dbo = conn.db(dbase);
    return await new  Promise(async(resolve, reject) => {
        let output={};
        try{
            output.status=200;
            output.data=await dbo.collection(collection).insert(insertobj);
            resolve(output);
        }catch(err){
            output.status=500;
            output.data=err;
            resolve(output);

        }
    });
}
// /*<summary>
//     <name> insertBulk </name>
//     <inputs>
//         (conn,dbase,collection,query,protion,sort,skip,limit)
//         conn        (#connection) \! 
//         dbase       (#text) \!
//         collection  (#text)  \!
//         /<<text
//         insertobj       (#query)  \!      ==> Example : [{},{},...]
//         protion     (#projection)  \!      ==> Default : {yo:0}
//         sort        (#sort)  \!      ==> Default : {id:1}
//         skip        (#int)  \!      ==> Default : 0
//         limit       (#int)  \!      ==> Default : 0
//         >>/
//     </inputs>
//     <returns>
//         output ===> object type
//         output.status ===> 200 برای اجرای درست;
//         output.status ===> 500 برای اجرای نادرست;
//         output.status ===> 404 فایل یافت نشد;
//         output.data    ===> برای 200 فایل از نوع بافر;
//         output.data    ===> برای 404 پیام ارور سیستم;
//     </returns> 
// </summary>
//  */
exports.piccounter=async function(conn,dbase,collection,id,regid){
    const dbo = conn.db(dbase);
    return await new  Promise(async(resolve, reject) => {
        let output={},findTHEN={},ch;
        try{
            output.status=200;
            findTHEN=await dbo.collection(collection).find({$and:[{_registerarid:regid*1},{_id:id*1}]}).toArray();
            ch=findTHEN[0].ax.split(',');
            if(ch.length<9){
                var num=findTHEN[0].axc+1;
                await dbo.collection(collection).updateOne({_id:id*1},{$set:{ax:findTHEN[0].ax+num+",",axc:num}});
                output.data=num;
            }else{
                output.status=401;
                output.data="limit 8 pic";
            }
            resolve(output);
        }catch(err){
            output.status=500;
            output.data=err;
            resolve(output);

        }
    });
}
// /*<summary>
//     <name> insertBulk </name>
//     <inputs>
//         (conn,dbase,collection,query,protion,sort,skip,limit)
//         conn        (#connection) \! 
//         dbase       (#text) \!
//         collection  (#text)  \!
//         /<<text
//         insertobj       (#query)  \!      ==> Example : [{},{},...]
//         protion     (#projection)  \!      ==> Default : {yo:0}
//         sort        (#sort)  \!      ==> Default : {id:1}
//         skip        (#int)  \!      ==> Default : 0
//         limit       (#int)  \!      ==> Default : 0
//         >>/
//     </inputs>
//     <returns>
//         output ===> object type
//         output.status ===> 200 برای اجرای درست;
//         output.status ===> 500 برای اجرای نادرست;
//         output.status ===> 404 فایل یافت نشد;
//         output.data    ===> برای 200 فایل از نوع بافر;
//         output.data    ===> برای 404 پیام ارور سیستم;
//     </returns> 
// </summary>
//  */
exports.picdel=async function(conn,dbase,collection,id,num){
    const dbo = conn.db(dbase);
    return await new  Promise(async(resolve, reject) => {
        let output={},findTHEN={};
        try{
            output.status=200;
            findTHEN=await dbo.collection(collection).find({$and:[{_id:id*1}]}).toArray(); //,{ok:false} why ?
            if(findTHEN.length>0){
                var ax=findTHEN[0].ax;
                await dbo.collection(collection).updateOne({_id:id*1},{$set:{ax:ax.replace(num+",","")}});
                output.data=true;
            }else{
                output.data=false;
                output.status=404;
            }
            resolve(output);
        }catch(err){
            output.status=500;
            output.data=err;
            resolve(output);

        }
    });
}




// collection.bulkWrite(
//     [{ insertOne: doc1}, { insertOne: doc2}],
//     {ordered:true});
// };
/////////////////////////////////////////// update
/*<summary>
    <name> updateONE </name>
    <inputs>
        (conn,dbase,collection,query,protion,sort,skip,limit)
        conn        (#connection) \! 
        dbase       (#text) \!
        collection  (#text)  \!
        /<<text
        query       (#query)  \!      ==> Default : {}
        protion     (#projection)  \!      ==> Default : {yo:0}
        sort        (#sort)  \!      ==> Default : {id:1}
        skip        (#int)  \!      ==> Default : 0
        limit       (#int)  \!      ==> Default : 0
        >>/
    </inputs>
    <returns>
        output ===> object type
        output.status ===> 200 برای اجرای درست;
        output.status ===> 500 برای اجرای نادرست;
        output.status ===> 404 فایل یافت نشد;
        output.data    ===> برای 200 فایل از نوع بافر;
        output.data    ===> برای 404 پیام ارور سیستم;
    </returns> 
</summary>
 */
exports.updateONE=async function(conn,dbase,collection,filter,set){
    const dbo = conn.db(dbase);
    return await new  Promise(async(resolve, reject) => {
        let output={};
        try{
            output.status=200;
             output.data=await dbo.collection(collection).updateOne(filter,{$set:set});
            resolve(output);
        }catch(err){
            output.status=500;
            output.data=err;
            resolve(output);

        }
    });
}
/*<summary>
    <name> updateONEfull </name>
    <inputs>
        (conn,dbase,collection,query,protion,sort,skip,limit)
        conn        (#connection) \! 
        dbase       (#text) \!
        collection  (#text)  \!
        /<<text
        query       (#query)  \!      ==> Default : {}
        protion     (#projection)  \!      ==> Default : {yo:0}
        sort        (#sort)  \!      ==> Default : {id:1}
        skip        (#int)  \!      ==> Default : 0
        limit       (#int)  \!      ==> Default : 0
        >>/
    </inputs>
    <returns>
        output ===> object type
        output.status ===> 200 برای اجرای درست;
        output.status ===> 500 برای اجرای نادرست;
        output.status ===> 404 فایل یافت نشد;
        output.data    ===> برای 200 فایل از نوع بافر;
        output.data    ===> برای 404 پیام ارور سیستم;
    </returns> 
</summary>
 */
exports.updateONEfull=async function(conn,dbase,collection,filter,set,final){
    const dbo = conn.db(dbase);
    return await new  Promise(async(resolve, reject) => {
        let output={};
        try{
            output.status=200;
             output.data=await dbo.collection(collection).updateOne(filter,{$set:set},final);
            resolve(output);
        }catch(err){
            output.status=500;
            output.data=err;
            resolve(output);

        }
    });
}
 

exports.upsertONEfull=async function(conn,dbase,collection,filter,obj,final){
    const dbo = conn.db(dbase);
    return await new  Promise(async(resolve, reject) => {
        let output={};
        try{
            output.status=200;
             output.data=await dbo.collection(collection).updateOne(filter,obj,final);
            resolve(output);
        }catch(err){
            output.status=500;
            output.data=err;
            resolve(output);

        }
    });
}
/*<summary>
    <name> updateONEfree </name>
    <inputs>
        (conn,dbase,collection,query,protion,sort,skip,limit)
        conn        (#connection) \! 
        dbase       (#text) \!
        collection  (#text)  \!
        /<<text
        query       (#query)  \!      ==> Default : {}
        protion     (#projection)  \!      ==> Default : {yo:0}
        sort        (#sort)  \!      ==> Default : {id:1}
        skip        (#int)  \!      ==> Default : 0
        limit       (#int)  \!      ==> Default : 0
        >>/
    </inputs>
    <returns>
        output ===> object type
        output.status ===> 200 برای اجرای درست;
        output.status ===> 500 برای اجرای نادرست;
        output.status ===> 404 فایل یافت نشد;
        output.data    ===> برای 200 فایل از نوع بافر;
        output.data    ===> برای 404 پیام ارور سیستم;
    </returns> 
</summary>
 */
exports.updateONEfree=async function(conn,dbase,collection,filter,updObj){
    const dbo = conn.db(dbase);
    return await new  Promise(async(resolve, reject) => {
        let output={};
        try{
            output.status=200;
             output.data=await dbo.collection(collection).updateOne(filter,updObj);
            // output.data=await dbo.collection(collection).update(filter,set);
            resolve(output);
        }catch(err){
            output.status=500;
            output.data=err;
            resolve(output);

        }
    });
}


/*<summary>
    <name> updateMANY </name>
    <inputs>
        (conn,dbase,collection,query,protion,sort,skip,limit)
        conn        (#connection) \! 
        dbase       (#text) \!
        collection  (#text)  \!
        /<<text
        query       (#query)  \!      ==> Default : {}
        protion     (#projection)  \!      ==> Default : {yo:0}
        sort        (#sort)  \!      ==> Default : {id:1}
        skip        (#int)  \!      ==> Default : 0
        limit       (#int)  \!      ==> Default : 0
        >>/
    </inputs>
    <returns>
        output ===> object type
        output.status ===> 200 برای اجرای درست;
        output.status ===> 500 برای اجرای نادرست;
        output.status ===> 404 فایل یافت نشد;
        output.data    ===> برای 200 فایل از نوع بافر;
        output.data    ===> برای 404 پیام ارور سیستم;
    </returns> 
</summary>
 */
exports.updateMANY=async function(conn,dbase,collection,filter,set){
    const dbo = conn.db(dbase);
    return await new  Promise(async(resolve, reject) => {
        let output={};
        try{
            output.status=200;
             output.data=await dbo.collection(collection).updateMany(filter,{$set:set});
            // output.data=await dbo.collection(collection).update(filter,set);
            resolve(output);
        }catch(err){
            output.status=500;
            output.data=err;
            resolve(output);

        }
    });
}
/*<summary>
    <name> updateMANYfree </name>
    <inputs>
        (conn,dbase,collection,query,protion,sort,skip,limit)
        conn        (#connection) \! 
        dbase       (#text) \!
        collection  (#text)  \!
        /<<text
        query       (#query)  \!      ==> Default : {}
        protion     (#projection)  \!      ==> Default : {yo:0}
        sort        (#sort)  \!      ==> Default : {id:1}
        skip        (#int)  \!      ==> Default : 0
        limit       (#int)  \!      ==> Default : 0
        >>/
    </inputs>
    <returns>
        output ===> object type
        output.status ===> 200 برای اجرای درست;
        output.status ===> 500 برای اجرای نادرست;
        output.status ===> 404 فایل یافت نشد;
        output.data    ===> برای 200 فایل از نوع بافر;
        output.data    ===> برای 404 پیام ارور سیستم;
    </returns> 
</summary>
 */
exports.updateMANYfree=async function(conn,dbase,collection,filter,updObj){
    const dbo = conn.db(dbase);
    return await new  Promise(async(resolve, reject) => {
        let output={};
        try{
            output.status=200;
             output.data=await dbo.collection(collection).updateMany(filter,updObj);
            // output.data=await dbo.collection(collection).update(filter,set);
            resolve(output);
        }catch(err){
            output.status=500;
            output.data=err;
            resolve(output);

        }
    });
}





















/////////////////////////////////////////// finds
/*<summary>
    <name> find </name>
    <inputs>
        (conn,dbase,collection,query,protion,sort,skip,limit)
        conn        (#connection) \! 
        dbase       (#text) \!
        collection  (#text)  \!
        /<<text
        query       (#query)  \!      ==> Default : {}
        protion     (#projection)  \!      ==> Default : {yo:0}
        sort        (#sort)  \!      ==> Default : {id:1}
        skip        (#int)  \!      ==> Default : 0
        limit       (#int)  \!      ==> Default : 0
        >>/
    </inputs>
    <returns>
        output ===> object type
        output.status ===> 200 برای اجرای درست;
        output.status ===> 500 برای اجرای نادرست;
        output.status ===> 404 فایل یافت نشد;
        output.data    ===> برای 200 فایل از نوع بافر;
        output.data    ===> برای 404 پیام ارور سیستم;
    </returns> 
</summary>
 */
exports.findfull=async function(conn,dbase,collection,query={},protion={yo:0},sort={},skip=0,limit=0){
    const projection = { projection:protion};
    const dbo = conn.db(dbase);
    return await new  Promise(async(resolve, reject) => {
        var chk={};
        chk.data=false;
        let output={};
        sort="";
        try{
            output.status=200;
            output.data=await dbo.collection(collection).find(query,projection).sort(sort).skip(skip).limit(limit).toArray();
            if(output.data.length==0){output.status=404;}
            resolve(output);
        }catch(err){
            output.status=500;
            output.data=err;
            resolve(output);

        }
    });
}
/////////////////////////////////////////// joins
/*<summary>
    <name> join2 </name>
    <inputs>
        (conn,dbase,collection,query,protion,sort,skip,limit)
        conn        (#connection) \! 
        dbase       (#text) \!
        collection  (#text)  \!
        /<<text
        query       (#query)  \!      ==> Default : {}
        protion     (#projection)  \!      ==> Default : {yo:0}
        sort        (#sort)  \!      ==> Default : {id:1}
        skip        (#int)  \!      ==> Default : 0
        limit       (#int)  \!      ==> Default : 0
        >>/
    </inputs>
    <returns>
        output ===> object type
        output.status ===> 200 برای اجرای درست;
        output.status ===> 500 برای اجرای نادرست;
        output.status ===> 404 فایل یافت نشد;
        output.data    ===> برای 200 فایل از نوع بافر;
        output.data    ===> برای 404 پیام ارور سیستم;
    </returns> 
</summary>
 */
exports.join2=async function(conn,dbase,collection_base,localField,collection_join,foreignField,query={},protion={yo:0},sort={_id:1},skip=0,limit=50000){
    const projection = { projection:protion};
    const dbo = conn.db(dbase);
    return await new  Promise(async(resolve, reject) => {
        var chk={};
        chk.data=false;
        let output={};
        //sort="";
        try{
            output.status=200;
            var args=[
                {$lookup:
                    {from: 
                        collection_join,
                        localField: localField,
                        foreignField: foreignField,
                         as: 'joinlist'}
                    }
                    ,
                    {$match :query},
                    {$project:protion},
                    {"$sort":sort},
                    {"$skip":skip},
                    {$limit:limit*1}
                ];
            output.data=await dbo.collection(collection_base).aggregate(args).toArray();
            if(output.data.length==0){output.status=404;}
            resolve(output);
        }catch(err){
            output.status=500;
            output.data=err;
            resolve(output);

        }
    });
}
/*<summary>
    <name> join2mergeONE </name>
    <inputs>
        (conn,dbase,collection,query,protion,sort,skip,limit)
        conn        (#connection) \! 
        dbase       (#text) \!
        collection  (#text)  \!
        /<<text
        query       (#query)  \!      ==> Default : {}
        protion     (#projection)  \!      ==> Default : {yo:0}
        sort        (#sort)  \!      ==> Default : {id:1}
        skip        (#int)  \!      ==> Default : 0
        limit       (#int)  \!      ==> Default : 0
        >>/
    </inputs>
    <returns>
        output ===> object type
        output.status ===> 200 برای اجرای درست;
        output.status ===> 500 برای اجرای نادرست;
        output.status ===> 404 فایل یافت نشد;
        output.data    ===> برای 200 فایل از نوع بافر;
        output.data    ===> برای 404 پیام ارور سیستم;
    </returns> 
</summary>
 */
exports.join2mergeONE=async function(conn,dbase,collection_base,localField,collection_join,foreignField,query={},protion={}){
    protion["joinlist"]=0;
    const dbo = conn.db(dbase);
    return await new  Promise(async(resolve, reject) => {
        // var chk={};
        // chk.data=false;
        let output={};
        //sort="";
        try{
            output.status=200;
            var args=[
                {$lookup:
                    {
                        from:collection_join,
                        localField: localField,
                        foreignField: foreignField,
                         as: 'joinlist'
                    }
                },
                {$match :query},
                {$replaceRoot: 
                    { newRoot: 
                        { $mergeObjects: 
                            [ 
                                { $arrayElemAt: 
                                    [ "$joinlist", 0 ]
                                },
                                "$$ROOT"
                            ]
                        }
                    }
                },
                {$project:protion}
            ];
            output.data=await dbo.collection(collection_base).aggregate(args).toArray();
            if(output.data.length==0){output.status=404;}
            resolve(output);
        }catch(err){
            output.status=500;
            output.data=err;
            resolve(output);

        }
    });
}
/*<summary>
    <name> join2merge </name>
    <inputs>
        (conn,dbase,collection,query,protion,sort,skip,limit)
        conn        (#connection) \! 
        dbase       (#text) \!
        collection  (#text)  \!
        /<<text
        query       (#query)  \!      ==> Default : {}
        protion     (#projection)  \!      ==> Default : {yo:0}
        sort        (#sort)  \!      ==> Default : {id:1}
        skip        (#int)  \!      ==> Default : 0
        limit       (#int)  \!      ==> Default : 0
        >>/
    </inputs>
    <returns>
        output ===> object type
        output.status ===> 200 برای اجرای درست;
        output.status ===> 500 برای اجرای نادرست;
        output.status ===> 404 فایل یافت نشد;
        output.data    ===> برای 200 فایل از نوع بافر;
        output.data    ===> برای 404 پیام ارور سیستم;
    </returns> 
</summary>
 */
exports.join2merge=async function(conn,dbase,collection_base,localField,collection_join,foreignField,query={},protion={},sort={_id:1},limit=50000,skip=0){
    protion["joinlist"]=0;
    const dbo = conn.db(dbase);
    return await new  Promise(async(resolve, reject) => {
        var chk={};
        chk.data=false;
        let output={};
        //sort="";
        try{
            output.status=200;
            var args=[
                {$lookup:
                    {
                        from:collection_join,
                        localField: localField,
                        foreignField: foreignField,
                         as: 'joinlist'
                    }
                },
                
                {$replaceRoot: 
                    { newRoot: 
                        { $mergeObjects: 
                            [ 
                                { $arrayElemAt: 
                                    [ "$joinlist", 0 ]
                                },
                                "$$ROOT"
                            ]
                        }
                    }
                },
                {$match :query},
                {$project:protion},
                {"$sort":sort},
                {"$skip":skip},
                {$limit:limit*1}
            ];
            output.data=await dbo.collection(collection_base).aggregate(args).toArray();
            if(output.data.length==0){output.status=404;}
            resolve(output);
        }catch(err){
            output.status=500;
            output.data=err;
            resolve(output);

        }
    });
}


/*<summary>
    <name> join3 </name>
    <inputs>
        (conn,dbase,collection,query,protion,sort,skip,limit)
        conn        (#connection) \! 
        dbase       (#text) \!
        collection  (#text)  \!
        /<<text
        query       (#query)  \!      ==> Default : {}
        protion     (#projection)  \!      ==> Default : {yo:0}
        sort        (#sort)  \!      ==> Default : {id:1}
        skip        (#int)  \!      ==> Default : 0
        limit       (#int)  \!      ==> Default : 0
        >>/
    </inputs>
    <returns>
        output ===> object type
        output.status ===> 200 برای اجرای درست;
        output.status ===> 500 برای اجرای نادرست;
        output.status ===> 404 فایل یافت نشد;
        output.data    ===> برای 200 فایل از نوع بافر;
        output.data    ===> برای 404 پیام ارور سیستم;
    </returns> 
</summary>
 */
exports.join3=async function(conn,dbase,collection_base,localField,collection_join,foreignField,query={},protion={yo:0},sort={_id:1},skip=0,limit=50000){
    const projection = { projection:protion};
    const dbo = conn.db(dbase);
    return await new  Promise(async(resolve, reject) => {
        var chk={};
        chk.data=false;
        let output={};
        //sort="";
        try{
            output.status=200;
            var args=[
                {$lookup:
                    {from: 
                        collection_join,
                        localField: localField,
                        foreignField: foreignField,
                         as: 'joinlist'}
                    }
                    ,
                    {$match :query},
                    {$project:protion},
                    {"$sort":sort},
                    {"$skip":skip},
                    {$limit:limit*1}
                ];
            output.data=await dbo.collection(collection_base).aggregate(args).toArray();
            if(output.data.length==0){output.status=404;}
            resolve(output);
        }catch(err){
            output.status=500;
            output.data=err;
            resolve(output);

        }
    });
}



// {$replaceRoot: 
//     { newRoot: 
//         { $mergeObjects: 
//             [ 
//                 { $arrayElemAt: 
//                     [ "$joinlist", 0 ]
//                 },
//                 "$$ROOT"
//             ]
//         }
//     }
// },
// {$project:protion},


/*<summary>
    <name> join3 </name>
    <inputs>
        (conn,dbase,collection,query,protion,sort,skip,limit)
        conn        (#connection) \! 
        dbase       (#text) \!
        collection  (#text)  \!
        /<<text
        query       (#query)  \!      ==> Default : {}
        protion     (#projection)  \!      ==> Default : {yo:0}
        sort        (#sort)  \!      ==> Default : {id:1}
        skip        (#int)  \!      ==> Default : 0
        limit       (#int)  \!      ==> Default : 0
        >>/
    </inputs>
    <returns>
        output ===> object type
        output.status ===> 200 برای اجرای درست;
        output.status ===> 500 برای اجرای نادرست;
        output.status ===> 404 فایل یافت نشد;
        output.data    ===> برای 200 فایل از نوع بافر;
        output.data    ===> برای 404 پیام ارور سیستم;
    </returns> 
</summary>
 */
// exports.join3mereg=async function(conn,dbase,collection_base,localField,collection_join,foreignField,query={},protion={yo:0},sort={_id:1},skip=0,limit=50000){
//     const projection = { projection:protion};
//     const dbo = conn.db(dbase);
//     return await new  Promise(async(resolve, reject) => {
//         var chk={};
//         chk.data=false;
//         let output={};
//         //sort="";
//         try{
//             output.status=200;
//             var args=[
  




//                 ];









//             output.data=await dbo.collection(collection_base).aggregate(args).toArray();
//             if(output.data.length==0){output.status=404;}
//             resolve(output);
//         }catch(err){
//             output.status=500;
//             output.data=err;
//             resolve(output);

//         }
//     });
// }







async	function db_join_three_new(db,dbase,collection_base,collection_join1,collection_join2,localField1,foreignField1,Let_obj,match_list,protion,sort){
    if(sort=="" || sort==undefined || sort=={}){sort={_id:1};}
    if(protion=="" || protion==undefined ){protion={};}
    var args=[  
        	{
        		$lookup: {
        			from: collection_join1,
                    let:Let_obj,
        			pipeline: [
        				{ $match:match_list[1]},
        				{
        					$lookup: {
        						from: collection_join2,
        						localField: localField1,
        						foreignField: foreignField1,
        						as: "joinlist2"
        					},
        				},
        			],
        			as: "joinlist1"
        		}
        	},{$match:match_list[0]},{$project:protion}
        ];
    var dbo = db.db(dbase);
     return await dbo.collection(collection_base).aggregate(args).sort(sort).toArray();
}













/*<summary>
    <name> aggregate one collection </name>
    <inputs>
        (conn,dbase,collection,query,protion,sort,skip,limit)
        conn        (#connection) \! 
        dbase       (#text) \!
        collection  (#text)  \!
        /<<text
        query       (#query)  \!      ==> Default : {}
        protion     (#projection)  \!      ==> Default : {yo:0}
        sort        (#sort)  \!      ==> Default : {id:1}
        skip        (#int)  \!      ==> Default : 0
        limit       (#int)  \!      ==> Default : 0
        >>/
    </inputs>
    <returns>
        output ===> object type
        output.status ===> 200 برای اجرای درست;
        output.status ===> 500 برای اجرای نادرست;
        output.status ===> 404 فایل یافت نشد;
        output.data    ===> برای 200 فایل از نوع بافر;
        output.data    ===> برای 404 پیام ارور سیستم;
    </returns> 
</summary>
 */
exports.aggregateONE=async function(conn,dbase,collection_base,args){
    const dbo = conn.db(dbase);
    return await new  Promise(async(resolve, reject) => {
        var chk={};
        chk.data=false;
        let output={};
        //sort="";
        try{
            output.status=200;
            // var args=[
            //     {"$facet":
            //         {
            //             "provinces": [
            //                 { $match: { _idstate: 0 } },
            //             ],
            //             "city": [
            //                 { $match: { _id: s.data[0]._id } },
            //             ]
            //         }
            //     }
            //     // {$lookup:
            //     //     {from: 
            //     //         collection_join,
            //     //         localField: localField,
            //     //         foreignField: foreignField,
            //     //          as: 'joinlist'}
            //     //     }
            //     //     ,
            //     //     {$match :query},
            //     //     {$project:protion},
            //     //     {"$sort":sort},
            //     //     {"$skip":skip},
            //     //     {$limit:limit*1}
            //     ];
            output.data=await dbo.collection(collection_base).aggregate(args).toArray();
            resolve(output);
        }catch(err){
            output.status=500;
            output.data=err;
            resolve(output);

        }
    });
}







exports.deleteONE=async function(conn,dbase,collection,filter){
    const dbo = conn.db(dbase);
    return await new  Promise(async(resolve, reject) => {
        let output={};
        try{
            output.status=200;
             output.data=await dbo.collection(collection).deleteOne(filter);
            // output.data=await dbo.collection(collection).update(filter,set);
            resolve(output);
        }catch(err){
            output.status=500;
            output.data=err;
            resolve(output);

        }
    });
}

exports.deleteMANY=async function(conn,dbase,collection,filter){
    const dbo = conn.db(dbase);
    return await new  Promise(async(resolve, reject) => {
        let output={};
        try{
            output.status=200;
             output.data=await dbo.collection(collection).deleteMany(filter);
            // output.data=await dbo.collection(collection).update(filter,set);
            resolve(output);
        }catch(err){
            output.status=500;
            output.data=err;
            resolve(output);

        }
    });
}

//-------------------Mongo functions

async function db_insert_many_new(con,dbase,collection,insertobjs){
	return new Promise((resolve, reject)=>{   // promise used to wait untill resive a result that can be error or the result of a request 
		var dbo = con.db(dbase);
		dbo.collection(collection).insertMany(insertobjs, (err, res)=> {
			if (err){console.log("err====="+err);
				//err_page(self,"مشکل شناسایی پایگاه داده یا جدول ها");
			}else{
				//return "0";
				resolve(res);
			}
		});
	});
				
}

async function db_delet_one_new(con,dbase,collection,id){
	return new Promise((resolve, reject)=>{
		var query = { _id:id*1  };
		var dbo = con.db(dbase);
		dbo.collection(collection).deleteOne(query, (err, res)=> {
			//console.log(res);
			if (err){
				//err_page(self,"مشکل شناسایی پایگاه داده یا جدول ها");
			}else{
				resolve(res);
			}
		});
	});
	
}

async function db_delet_from_embeded_array(con,dbase,collection,match,query){
	return new Promise((resolve, reject)=>{
		var dbo=con.db(dbase);
		dbo.collection(collection).updateMany(match,{$pull:query},(err, res)=>{
			if(err){
				//console.log("ERROR")
			}else{
				resolve(res);
			}
		});
	});
}





async function db_delet_from_embeded_object(con,dbase,collection,match,query){
	//console.log(query);
	return new Promise((resolve, reject)=>{
		var dbo=con.db(dbase); 
		dbo.collection(collection).updateMany(match,{$unset:query},(err, res)=>{
			if(err){
				console.log("================ERROR");
			}else{
				resolve(res);
			}
		});
	});
}


async function db_delet_many(con,dbase,collection,filter){
	return new Promise((resolve, reject)=>{
		var dbo=con.db(dbase);
		dbo.collection(collection).deleteMany(filter,(err, res)=>{
			if(err){
				console.log("================ERROR");
			}else{
				resolve(res);
			}
		});
	});
}

















// async	function db_join_tow_free2(db,dbase,collection_base,collection_join,localField,foreignField,Let_obj,match_list,protion,sort){
//     if(sort=="" || sort==undefined || sort=={}){sort={_id:1};}
//     if(protion=="" || protion==undefined ){protion={};}

//     var args=[
// 		{
// 			$lookup:{
// 				from: collection_join,
// 				localField: localField,
// 				foreignField: foreignField, 
// 				let:Let_obj,
// 				pipeline:[
// 					{ $match:match_list[1]}
// 				],
// 				as: 'joinlist'
// 			}
// 		},{$match :match_list[0]},{$project:protion}
// 		];
    
// 	var dbo = db.db(dbase);
//     return await dbo.collection(collection_base).aggregate(args).sort(sort).toArray();
// }


async	function db_join_three_new(db,dbase,collection_base,collection_join1,collection_join2,localField1,foreignField1,Let_obj,match_list,protion,sort){
    if(sort=="" || sort==undefined || sort=={}){sort={_id:1};}
    if(protion=="" || protion==undefined ){protion={};}
    var args=[  
        	{
        		$lookup: {
        			from: collection_join1,
                    let:Let_obj,
        			pipeline: [
        				{ $match:match_list[1]},
        				{
        					$lookup: {
        						from: collection_join2,
        						localField: localField1,
        						foreignField: foreignField1,
        						as: "joinlist2"
        					},
        				},
        			],
        			as: "joinlist1"
        		}
        	},{$match:match_list[0]},{$project:protion}
        ];
    var dbo = db.db(dbase);
     return await dbo.collection(collection_base).aggregate(args).sort(sort).toArray();
}


async	function db_join_four_new(db,dbase,collection_base,collection_join1,collection_join2,collection_join3,localField1,foreignField1,Let_obj,match_list,protion,sort){
    if(sort=="" || sort==undefined || sort=={}){sort={_id:1};}
    if(protion=="" || protion==undefined ){protion={};}
    var args=[  
        	{
        		$lookup: {
        			from: collection_join1,
                    let:Let_obj[0],
        			pipeline: [
        				{ $match:match_list[1]},
        				{
        					$lookup: {
        						from: collection_join2,
        						let:Let_obj[1],
								pipeline:[
									{ $match:match_list[2]},
									{
										$lookup:{
											from:collection_join3,
        									localField: localField1,
        									foreignField: foreignField1,
											as: "joinlist3"
										}
									}
								],
        						as: "joinlist2"
        					},
        				},
        			],
        			as: "joinlist1"
        		}
        	},{$match:match_list[0]},{ $project : protion }
        ];
    var dbo = db.db(dbase);
     return await dbo.collection(collection_base).aggregate(args).sort(sort).toArray();
}





//----------------------------------------------------------- Json file


function del_file(fs,filename){
	fs.unlink(filename, err => {
		if (err) throw err;
	});
}



// connect to mongo db

async	function dbconnectmongo(url){
    var MongoClient = require('mongodb').MongoClient;
    //var url = "mongodb://localhost:27017/";
     var con=await MongoClient.connect(url,{ useNewUrlParser: true, useUnifiedTopology: true });
     return con;
}


async	function db_join_tempunit_tempsub_template(db,dbase,collection_base,collection_join1,collection_join2,localField1,foreignField1,Let_obj,match_list,protion,sort){
    if(sort=="" || sort==undefined || sort=={}){sort={_id:1};}
    if(protion=="" || protion==undefined ){protion={};}
    var args=[  
        	{
        		$lookup: {
        			from: collection_join1,
                    let:Let_obj,
        			pipeline: [
        				{ $match:match_list[1]},
        				{
        					$lookup: {
        						from: collection_join2,
        						localField: localField1,
        						foreignField: foreignField1,
        						as: "joinlist_tempunit"
        					},
        				},
        			],
        			as: "joinlist_subtemp"
        		}
        	},{$match:match_list[0]}
        ];
    var dbo = db.db(dbase);
     return await dbo.collection(collection_base).aggregate(args).sort(sort).toArray();
}





async	function db_join_template_options(db,dbase,collection_base,collection_join,lst,protion,sort){
    if(sort=="" || sort==undefined || sort=={}){sort={_id:1};}
    if(protion=="" || protion==undefined ){protion={};}
    var args=[
            { $match:{ $expr:{ $in: [ "$_id", lst ] } } },
        	{
        		$lookup: {
        			from:collection_join,
                    let: { listId: "$idList"},
        			pipeline: [
        				{ $match:{ $expr:{ $in: [ "$_id", "$$listId" ] } } },
        			],
        			as: "joinlist"
        		},
        	},
        ];
    var dbo = db.db(dbase);
     return await dbo.collection(collection_base).aggregate(args).sort(sort).toArray();
}



async function db_find_query_list_free(con,dbase,collection,query,protion,sortobj){
     var dbo = con.db(dbase);
             var projection = { projection: protion};
         var list= await dbo.collection(collection).find(query,projection).sort(sortobj).toArray();
    return list;
}




async function db_find_query_list_free(con,dbase,collection,query,protion,sort){
			//console.log(query);
 			var dbo = con.db(dbase);
 		 	var projection = { projection: protion};
			var list1= await dbo.collection(collection).find(query,projection).toArray(sort);
	 return list1;
}



async function db_delet_one_new(con,dbase,collection,query){
	return new Promise((resolve, reject)=>{
		var dbo = con.db(dbase);
		dbo.collection(collection).deleteOne(query, (err, res)=> {
			//console.log(res);
			if (err){
				//err_page(self,"مشکل شناسايي پايگاه داده يا جدول ها");
			}else{
				resolve(res);
			}
		});
	});
	
}

async function db_delet_from_embeded_array(con,dbase,collection,match,query){
	return new Promise((resolve, reject)=>{
		var dbo=con.db(dbase);
		dbo.collection(collection).updateMany(match,{$pull:query},(err, res)=>{
			if(err){
				//console.log("ERROR")
			}else{
				resolve(res);
			}
		});
	});
}


async function db_delet_from_embeded_object(con,dbase,collection,match,query){
	//console.log(query);
	return new Promise((resolve, reject)=>{
		var dbo=con.db(dbase); 
		dbo.collection(collection).updateMany(match,{$unset:query},(err, res)=>{
			if(err){
				console.log("================ERROR");
			}else{
				resolve(res);
			}
		});
	});
}


async function db_delet_many(con,dbase,collection,filter){
	return new Promise((resolve, reject)=>{
		var dbo=con.db(dbase);
		dbo.collection(collection).deleteMany(filter,(err, res)=>{
			if(err){
				console.log("================ERROR");
			}else{
				resolve(res);
			}
		});
	});
}




async	function db_join_tow_free(db,dbase,collection_base,collection_join,localField,foreignField,query,protion,sort){
    if(sort=="" || sort==undefined || sort=={}){sort={_id:1};}
    if(protion=="" || protion==undefined ){protion={};}
    var args=[{$lookup:{from: collection_join,localField: localField,foreignField: foreignField, as: 'joinlist'}},{$match :query},{$project:protion}];
    var dbo = db.db(dbase);
     return await dbo.collection(collection_base).aggregate(args).sort(sort).toArray();
}

async	function db_join_tempunit_tempsub_template(db,dbase,collection_base,collection_join1,collection_join2,localField1,foreignField1,Let_obj,match_list,protion,sort){
    if(sort=="" || sort==undefined || sort=={}){sort={_id:1};}
    if(protion=="" || protion==undefined ){protion={};}
    var args=[  
        	{
        		$lookup: {
        			from: collection_join1,
                    let:Let_obj,
        			pipeline: [
        				{ $match:match_list[1]},
        				{
        					$lookup: {
        						from: collection_join2,
        						localField: localField1,
        						foreignField: foreignField1,
        						as: "joinlist_tempunit"
        					},
        				},
        			],
        			as: "joinlist_subtemp"
        		}
        	},{$match:match_list[0]}
        ];
    var dbo = db.db(dbase);
     return await dbo.collection(collection_base).aggregate(args).sort(sort).toArray();
}

function write_jasoFile(fs,list,fs_name){let data = JSON.stringify(list);fs.writeFileSync(fs_name, data);}
function del_file(fs,filename){
	fs.unlink(filename, err => {
		if (err) throw err;
	});
}
function idmaker(controller,name,list){
	return ++list[name];
}
async function db_find_query_list(controller,dbase,collection,query,protion,sms){
	var self=controller;
	const  MongoClient = require('mongodb').MongoClient;
	const  url = "mongodb://localhost:27017/";
	 var db=await MongoClient.connect(url,{ useNewUrlParser: true, useUnifiedTopology: true });
 			var dbo = db.db(dbase);
 		 	var projection = { projection: protion};
			var list1= await dbo.collection(collection).find(query,projection).toArray();
			 db.close();
	 return list1;
}
function db_delet_one(controller,dbase,collection,id){
	var self=controller;
	var MongoClient = require('mongodb').MongoClient;
	var url = "mongodb://localhost:27017/";
	MongoClient.connect(url,{useNewUrlParser: true, useUnifiedTopology: true}, function(err, db) {
		if (err){
			err_page(self,"مشکل ارتباط با ودیریت پایگاه داده");
		}else{
			var query = { _id:id*1  };
			var dbo = db.db(dbase);
			dbo.collection(collection).deleteOne(query, (err, res)=> {
				if (err){
					err_page(self,"مشکل شناسایی پایگاه داده یا جدول ها");
				}else{
					db.close();
					return "0";
				}
		});
		}
	});
}





//////////////////
function err_page(controller,sms){
	var self = controller;
	smsmodel.sms=sms;
	// self.layout('layouts/admin');
	controller.redirect('/api/err/');
}
////////////////////////////








async	function db_join_tow_merg_free(db,dbase,collection_base,collection_join,localField,foreignField,query,protion,sort){
    if(sort=="" || sort==undefined || sort=={}){sort={_id:1};}
    //if(protion=="" || protion==undefined || protion=={}){protion={"joinlist":0};}else{protion.joinlist=0}
    var args=[{$lookup:{from: collection_join,localField: localField,foreignField: foreignField, as: 'joinlist'}},{$match :query},{
         $replaceRoot: { newRoot: { $mergeObjects: [ { $arrayElemAt: [ "$joinlist", 0 ] }, "$$ROOT" ] } }
    },{$project:{joinlist:0}}];
    var dbo = db.db(dbase);
     return await dbo.collection(collection_base).aggregate(args).sort(sort).toArray();
}

